**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets Lliqnworth Dliqnworth"
global MacroCovar "Lmedhp Dmedhp Lurate Durate Lmedinc Dmedinc Lmeddebt Dmeddebt"


//Table MD 3 
//Panel A: Effects on Mortgage Debt - by Income Quantile

*Home Debt
eststo m1: quietly xtreg Dhomedebttoinc c.dgini#i.Lincg i.Lincg c.($MacroCovar)#i.Lincg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m2: quietly xtreg Dopropdebttoinc c.dgini#i.Lincg i.Lincg c.($MacroCovar)#i.Lincg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

//Panel B: Effects on Mortgage Debt - by Financial Prosperity

*Home Debt
eststo m3: quietly xtreg Dhomedebttoinc c.dgini#i.Lselfrank i.Lselfrank c.($MacroCovar)#i.Lselfrank $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m4: quietly xtreg Dopropdebttoinc c.dgini#i.Lselfrank i.Lselfrank c.($MacroCovar)#i.Lselfrank $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 using "Tables\Table MD 3 - By Income Quantile and Financial Prosperity - nonstd.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


//Table MD 4
//Panel A: Effects on Mortgage Debt - by Life Cycle

*Home Debt
eststo m1: quietly xtreg Dhomedebttoinc c.dgini#i.Lageg i.Lageg c.($MacroCovar)#i.Lageg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m2: quietly xtreg Dopropdebttoinc c.dgini#i.Lageg i.Lageg c.($MacroCovar)#i.Lageg $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)

//Panel B: Effects on Mortgage Debt - by Housing Status

*Home Debt
eststo m3: quietly xtreg Dhomedebttoinc c.dgini#i.Lhsa i.Lhsa c.($MacroCovar)#i.Lhsa $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m4: quietly xtreg Dopropdebttoinc c.dgini#i.Lhsa i.Lhsa c.($MacroCovar)#i.Lhsa $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 using "Tables\Table MD 4 - By Life Cycle and Housing Status - nonstd.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


//Table MD 5
//Panel A: Effects on Mortgage Debt - by Htm

*Home Debt
eststo m1: quietly xtreg Dhomedebttoinc c.dgini#i.Lhtm i.Lhtm c.($MacroCovar)#i.Lhtm $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m2: quietly xtreg Dopropdebttoinc c.dgini#i.Lhtm i.Lhtm c.($MacroCovar)#i.Lhtm $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)

//Panel B: Effects on Mortgage Debt - by Ability to Raise Money Easily

*Home Debt
eststo m3: quietly xtreg Dhomedebttoinc c.dgini#i.Leasyraise i.Leasyraise c.($MacroCovar)#i.Leasyraise $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m4: quietly xtreg Dopropdebttoinc c.dgini#i.Leasyraise i.Leasyraise c.($MacroCovar)#i.Leasyraise $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)

//Panel C: Effects on Mortgage Debt - by Need to Borrow from Financial Insitution

*Home Debt
eststo m5: quietly xtreg Dhomedebttoinc c.dgini#i.Lborrowfin i.Lborrowfin c.($MacroCovar)#i.Lborrowfin $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m6: quietly xtreg Dopropdebttoinc c.dgini#i.Lborrowfin i.Lborrowfin c.($MacroCovar)#i.Lborrowfin $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)

//Panel D: Effects on Mortgage Debt - by Saving Habit

*Home Debt
eststo m7: quietly xtreg Dhomedebttoinc c.dgini#i.Lsaver i.Lsaver c.($MacroCovar)#i.Lsaver $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m8: quietly xtreg Dopropdebttoinc c.dgini#i.Lsaver i.Lsaver c.($MacroCovar)#i.Lsaver $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)

//Panel E: Effects on Mortgage Debt - by Financial Risk

*Home Debt
eststo m9: quietly xtreg Dhomedebttoinc c.dgini#i.Lfinrisk i.Lfinrisk c.($MacroCovar)#i.Lfinrisk $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other Property Debt
eststo m10: quietly xtreg Dopropdebttoinc c.dgini#i.Lfinrisk i.Lfinrisk c.($MacroCovar)#i.Lfinrisk $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year if exclude==0 & L.mortgagedebt>0,  vce(cluster hhssa3)


*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 using "Tables\Table MD 5 - By HTM and Financial Attitude - nonstd.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps


